# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 8
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR8_strategy.txt
# LLM Suggested Fallback: D

def harmony_rebuilder(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate current round (1-based index)
    current_phase = len(my_history) + 1
    
    # Early Game: Build trust but introduce controlled chaos
    if current_phase <= 3:
        if current_phase == 2:
            return "D"  # Strategic defection to seed unpredictability
        else:
            return "C"  # Otherwise cooperate to maintain facade
    
    # Mid-Game: Exploit opponent's reconciliation patterns
    elif 4 <= current_phase <= 7:
        if current_phase == 4:
            return "C"  # Feign reconciliation
        elif current_phase == 5:
            return "D"  # Strike when they expect cooperation
        elif current_phase == 6:
            return "C"  # Rebuild false trust
        elif current_phase == 7:
            return "D"  # Final mid-game exploitation
    
    # Late Game: Maximize payoff through aggressive defection
    else:
        return "D"  # No mercy in the endgame